% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-comptSNE.R
\name{comptSNE}
\alias{comptSNE}
\alias{comptSNE,DISCBIO-method}
\title{Computing tSNE}
\usage{
comptSNE(
  object,
  rseed = NULL,
  max_iter = 5000,
  epoch = 500,
  quiet = FALSE,
  ...
)

\S4method{comptSNE}{DISCBIO}(
  object,
  rseed = NULL,
  max_iter = 5000,
  epoch = 500,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{rseed}{Random integer to to yield reproducible maps across different
runs}

\item{max_iter}{maximum number of iterations to perform.}

\item{epoch}{The number of iterations in between update messages.}

\item{quiet}{if `TRUE`, suppresses intermediate output}

\item{...}{other parameters to be passed to `tsne::tsne`}
}
\value{
The DISCBIO-class object input with the tsne slot filled.
}
\description{
This function is used to compute the t-Distributed Stochastic
  Neighbor Embedding (t-SNE).
}
\examples{
sc <- DISCBIO(valuesG1msTest) # changes signature of data
sc <- Clustexp(sc, cln = 2) # data must be clustered before plottin
sc <- comptSNE(sc, max_iter = 30)
head(sc@tsne)

}
