% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfiMI_lasso.R
\name{DfiMI_lasso}
\alias{DfiMI_lasso}
\title{Distributed Full-information Multiple Imputation (DfiMI) using LASSO}
\description{
  Performs multiple imputation of the response variable  Y  via  R  independent
  runs and  M  stochastic imputations per run. Missing  Y  values are imputed
  using LASSO regression on predictors.
}
\usage{
DfiMI_lasso(data, R, M)
}
\arguments{
  \item{data}{
    A \code{data.frame} where:
    \describe{
      \item{First column:}{Response Y (may contain NA)}
      \item{Remaining columns:}{Numeric predictors}
    }
  }
  \item{R}{
    Positive integer -- number of simulation runs for stable coefficient estimation.
  }
  \item{M}{
    Positive integer -- number of multiple imputations per run.
  }
}
\details{
  This function extends the Distributed Full-information Multiple Imputation (DfiMI) approach
  by using LASSO regression for imputing missing values in the response variable Y.
  LASSO regression is particularly useful for high-dimensional predictor spaces and can
  handle multicollinearity among predictors. The function performs the following steps:
  \enumerate{
    \item Initialize missing values in Y.
    \item Fit LASSO regression models on complete cases.
    \item Average coefficients across multiple imputations and runs.
    \item Predict missing values using the final averaged coefficients.
  }
  The function requires the glmnet package for LASSO regression.
}
\value{
  A named list containing:
  \describe{
    \item{Yhat}{
      Numeric vector -- original Y values with missing values replaced by imputations.
    }
    \item{betahat}{
      Numeric vector -- final regression coefficients.
    }
  }
}
\examples{
set.seed(123)
data <- data.frame(
  Y = c(rnorm(50), rep(NA, 10)),  # 50 observed + 10 missing
  X1 = rnorm(60),
  X2 = rnorm(60)
)
res <- DfiMI_lasso(data, R = 3, M = 5)
head(res$Yhat)
}