% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{boxplot.DNAmixture}
\alias{boxplot.DNAmixture}
\title{Plot simulated peak heights for multiple DNA mixtures.}
\usage{
\method{boxplot}{DNAmixture}(
  x,
  sims,
  traces = 1:x$ntraces,
  markers = x$markers,
  pw = 0.4,
  ylim = NULL,
  border = "grey",
  ...
)
}
\arguments{
\item{x}{A \code{DNAmixture}.}

\item{sims}{A set of simulated peak heights. See also \code{\link{rPeakHeight}}.}

\item{traces}{Selected traces to plot.}

\item{markers}{Selected markers to plot.}

\item{pw}{Peaks are \code{2*pw} wide.}

\item{ylim}{Range of the y-axis.}

\item{border}{Color of the boxes.}

\item{...}{Arguments passed on to \code{plot.DNAmixture}.}
}
\value{
Invisibly the peak heights as used for the boxplots.
}
\description{
A plot will be made for each combination of samples and markers
specified, and it is up to the user to specify a layout for the
plots (e.g. via calls to \code{\link{par}})

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which
is intended as a service to enable users to try \pkg{DNAmixtures}
without purchasing a commercial licence for Hugin. When at all
possible, we strongly recommend the use of \pkg{DNAmixtures}
rather than this lite-version. See
\url{https://dnamixtures.r-forge.r-project.org/} for details on
both packages.}

\emph{While the lite-version seeks to provide the full functionality of
\pkg{DNAmixtures}, note that computations are much less efficient
and that there are some differences in available functionality. Be
aware that the present documentation is copied from
\pkg{DNAmixtures} and thus may not accurately describe the
implementation of this lite-version.}
}
\examples{

data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = c("K1", "K3"),
                  database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = c(0.08,0.08),
            phi = list(c(U1 = 0.1, K3 = 0.2, K1 = 0.7), c(K1 = 0.9, K3 = 0.05, U1 = 0.05)))
rpm <- rPeakHeight(mix, p, nsim = 1000, dist = "joint")
oldpar <- par("mfrow")
par(mfrow = c(1,2))
boxplot(mix, rpm, traces = 1:2, markers = "VWA")
par(mfrow = oldpar)

\donttest{
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = "K3", database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = c(0.08,0.08),
            phi = list(c(U2 = 0.1, K3 = 0.2, U1 = 0.7), c(U1 = 0.9, K3 = 0.05, U2 = 0.05)))
rpm <- rPeakHeight(mix, p, nsim = 50, dist = "joint")
rpc <- rPeakHeight(mix, p, nsim = 50, dist = "conditional")
oldpar <- par("mfrow")
par(mfrow = c(2,2))
boxplot(mix, rpm, traces = 1:2, markers = "VWA") ## First row of plots
boxplot(mix, rpc, traces = 1:2, markers = "VWA") ## Second row of plots
par(mfrow = oldpar)
mixK <- DNAmixture(list(MC15, MC18), C = list(50, 38), k = 3, K = c("K1", "K2", "K3"),
                    database = USCaucasian)
pK <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08,0.08),
             phi = list(c(K2 = 0.1, K3 = 0.2, K1 = 0.7), c(K2 = 0.1, K3 = 0.2, K1 = 0.7)))
rpmK <- rPeakHeight(mixK, pK, nsim = 1000, markers = "D2S1338")
oldpar <- par(mfrow = c(1,2))
boxplot(mixK, rpmK, markers = "D2S1338")
par(oldpar)
}
}
\author{
Therese Graversen
}
