% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pnm_all.R
\name{Pnm_all}
\alias{Pnm_all}
\alias{pNoA}
\alias{p.numberofalleles}
\alias{Pnm_locus}
\alias{convolve}
\title{The exact distribution of the number of alleles in a m-person DNA mixture}
\usage{
Pnm_all(m, theta, probs, locuswise = FALSE)
Pnm_locus(m, theta, alleleProbs)
}
\arguments{
\item{m}{The number of contributors}

\item{theta}{The coancestery coefficient}

\item{probs}{List of vectors with allele probabilities for each locus}

\item{locuswise}{Logical. If \code{TRUE} the locus-wise probabilities will be
returned. Otherwise, the probability over all loci is returned.}

\item{alleleProbs}{Vectors with allele probabilities}
}
\value{
Returns a vector of probabilities, or a matrix of locuswise
probability vectors.
}
\description{
Computes the exact distribution of the number of alleles in a \eqn{m}-person DNA
mixture typed with STR loci. For a m-person DNA mixture it is possible to
observe \eqn{1,\ldots,2\times m \times L}{1,...,2mL} alleles, where \eqn{L} is 
the total number of typed STR loci. The method allows incorporation of the 
subpopulation correction, the so-called \eqn{\theta}{theta}-correction, to adjust 
for shared ancestry. If needed, the locus-specific probabilities can be obtained using the
\code{locuswise} argument.
}
\details{
Computes the exact distribution of the number of alleles for a m-person DNA
mixture.
}
\examples{

  ## Simulate some allele frequencies:
  freqs <-  structure(replicate(10, { g = rgamma(n = 10, scale = 4, shape = 3); 
                                      g/sum(g)
                                    },
              simplify = FALSE), .Names = paste('locus', 1:10, sep = '.'))

  ## Compute \eqn{\Pr(N(m = 3) = n)}, \eqn{n = 1,\ldots,2 * L *m}, where \eqn{L = 10}
  ## here
  Pnm_all(m = 2, theta = 0, freqs)
  ## Same, but locuswise results
  Pnm_all(m = 2, theta = 0, freqs, locuswise = TRUE)
  
}
\references{
T. Tvedebrink (2014). 'On the exact distribution of the number of 
alleles in DNA mixtures', International Journal of Legal Medicine; 128(3):427--37. 
<https://doi.org/10.1007/s00414-013-0951-3>
}
\author{
Torben Tvedebrink, James Curran, Mikkel Andersen
}
