% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdrtest_em.R
\name{drdrtest_em.superlearner}
\alias{drdrtest_em.superlearner}
\title{The function for testing a effect modifier with SuperLearner}
\usage{
drdrtest_em.superlearner(
  y,
  a,
  l,
  class_label,
  arange,
  pi.sl.lib = c("SL.earth", "SL.glm", "SL.gam", "SL.glmnet"),
  mu.sl.lib = c("SL.earth", "SL.glm", "SL.gam", "SL.glmnet"),
  mu.family = "gaussian",
  h = NULL,
  b = 1000,
  dist = "TwoPoint",
  pi.low = 0.01,
  pi.var.low = 0.01,
  a.grid.size = 401
)
}
\arguments{
\item{y}{A vector containing the outcomes for each observation}

\item{a}{A vector containing the treatment levels (dosage) for each observation}

\item{l}{A data.frame containing the observations of covariates}

\item{class_label}{A vector containing the class label (label for the effect modifier) for each observation.}

\item{arange}{A vector of length 2 giving the lower bound and upper bound of  treatment levels}

\item{pi.sl.lib}{Models will be used by SuperLearner to estiamte propensity scores}

\item{mu.sl.lib}{Models will be used by SuperLearner to estiamte outcome regression function}

\item{mu.family}{Type of response. Currently only support "gaussian" and "binomial"}

\item{h}{bandwidth to be used in kernel regression. If not specified, will by default use "rule of thumb" bandwidth selector}

\item{b}{number of Bootstrap samples to be generated}

\item{dist}{distibution used to generate residuals for Bootstrap samples. Currently only have two options, "TwoPoint" and "Rademachar"}

\item{pi.low}{Lower bound to truncate propensity scores}

\item{pi.var.low}{Lower bound to truncate conditional variance of treament (used in propensity score estimation).}

\item{a.grid.size}{size of equally spaced grid points over \code{arange} to be generate for numerically evaluating the integral in test statistic}
}
\value{
A list containing \describe{
\item{p.value:}{P value of the test result}
\item{test.stat:}{Value of the observed test statistic}
\item{Bootstrap.samples:}{A vector containing test statistic values from Bootstrap samples}
\item{bandwidth:}{Bandwidth used in kernel regression}
}
}
\description{
This is the  function for testing whether a discrete covariate is an effect modifier with SuperLearner
}
\examples{
d <- 4
n <- 200
sigma <- 0.5
delta <- 1
height <-1
arange <- c(0,5)
triangle <- function(a,height){
   y <- exp(-a^2/((1/2)^2))*height
   return(y)
}
mu.mod<-function(a,l,delta,height){
   mu <- as.numeric(l\%*\%c(0.2,0.2,0.3,-0.1*delta))+
         triangle(a-2.5,height)+a*(-0.1*l[,1]+0.1*delta*l[,4])
   return(mu)
}
l <- matrix(rnorm(n*d),ncol=d)
l[,4] <- ifelse(l[,4]>0,1,0)
colnames(l) <- paste("l",1:4,sep="")

logit.lambda <- as.numeric(l\%*\%c(0.1,0.1,-0.1,0))
lambda <- exp(logit.lambda)/(1+exp(logit.lambda))
a <- rbeta(n, shape1 = lambda, shape2 =1-lambda)*5

mu <- mu.mod(a,l,delta,height)
residual.list <- rnorm(n,mean=0,sd =sigma)
y <- mu+residual.list

class_label <- l[,4]
out <- drdrtest_em.superlearner(y,a,l,l[,4],arange,pi.sl.lib=c("SL.glm"),mu.sl.lib=c("SL.glm"))
}
