#' Docetaxel KM data used for reconstructing PFS KM curve
#'
#' Kaplan-Meier (KM) survival data for the standard-of-care (SOC) arm (docetaxel), extracted using PlotDigitizer from a published KM curve. This dataset is used to reconstruct the progression-free survival (PFS) curve for trial simulation and validation.
#'
#' @format A data frame with two variables:
#' \describe{
#'   \item{time}{Numeric. Time points (e.g., in months) at which survival probabilities are estimated.}
#'   \item{survival}{Numeric. Estimated survival probability corresponding to each time point.}
#' }
#' @usage data(SOC)
#' @examples
#' data(SOC)
#' head(SOC)
"SOC"
