% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pe.R
\name{generate_pe}
\alias{generate_pe}
\title{Generate event times from a piecewise exponential distribution.}
\usage{
generate_pe(n, t, lambda1, lambda2)
}
\arguments{
\item{n}{Integer. Number of event times  to generate (i.e., sample size).}

\item{t}{Numeric. Separation timepoint at which the hazard rate changes.}

\item{lambda1}{Numeric. Constant hazard rate before the separation timepoint.}

\item{lambda2}{Numeric. Constant hazard rate after the separation timepoint.}
}
\value{
A numeric vector of length \code{n}, representing simulated survival times
drawn from a piecewise exponential distribution with hazard rate \code{lambda1}
before time \code{t}, and \code{lambda2} after time \code{t}.
Times are expressed in the same time unit as specified in the hazard rate (typically months)
}
\description{
Generates random event times under a piecewise exponential distribution, where different constant hazard rates apply before and after a specified separation timepoint. This is commonly used for simulating survival data with delayed treatment effects.
}
\examples{
set.seed(42)
generate_pe(1000, 1, 1, 0.5)
}
