% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cholera_deaths_1849_tbl_df}
\alias{cholera_deaths_1849_tbl_df}
\title{Cholera Daily Deaths in England, 1849}
\format{
A tibble with 730 observations and 6 variables:
\describe{
  \item{month}{Character indicating the month of observation}
  \item{cause_of_death}{Factor with 2 levels indicating cause of death (Cholera or Diarrhaea)}
  \item{day_of_month}{Character indicating the day of the month}
  \item{deaths}{Numeric value indicating the number of deaths}
  \item{date}{Date object indicating the exact date}
  \item{day_of_week}{Ordered factor with 7 levels indicating the day of week}
}
}
\source{
Data taken from the \pkg{HistData} package version 0.9-3. Original source: Bingham P., Verlander, N. Q., Cheal M. J. (2004).
"John Snow, William Farr and the 1849 outbreak of cholera that affected London: a reworking of the data highlights the importance of the water supply".
\emph{Public Health}, 118(6), 387--394, Table 2.
}
\usage{
data(cholera_deaths_1849_tbl_df)
}
\description{
This dataset, cholera_deaths_1849_tbl_df, is a tibble containing daily deaths
from Cholera and Diarrhaea in England for each day of the 12 months of 1849.
It includes the month, cause of death, day of month, number of deaths, date,
and day of week for each observation.
}
\details{
The dataset name has been kept as 'cholera_deaths_1849_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
