clean_disaster_text <- function(text) {
  
  # Convert to character and handle NAs
  text <- as.character(text)
  text[is.na(text)] <- ""
  
  # Remove special characters and convert to lowercase
  text <- gsub("[^a-zA-Z\\s]", "", tolower(text))
  
  # Remove extra whitespace
  text <- gsub("\\s+", " ", text)
  text <- trimws(text)
  
  # Remove common stop words
  stop_words <- c("the", "and", "or", "but", "in", "on", "at", "to", "for", 
                  "of", "with", "by", "is", "are", "was", "were", "be", "been",
                  "have", "has", "had", "do", "does", "did", "will", "would",
                  "could", "should", "may", "might", "must", "can", "a", "an",
                  "this", "that", "these", "those", "i", "you", "he", "she",
                  "it", "we", "they", "me", "him", "her", "us", "them")
  
  # Remove stop words
  for (i in seq_along(text)) {
    words <- unlist(strsplit(text[i], "\\s+"))
    words <- words[!words %in% stop_words & nchar(words) > 2]
    text[i] <- paste(words, collapse = " ")
  }
  
  return(text)
}