% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateGumbelCopula.R
\name{bivariateGumbel}
\alias{bivariateGumbel}
\alias{cBivariateGumbel}
\alias{cdBivariateGumbel}
\alias{crBivariateGumbel}
\title{Bivariate Gumbel Copula}
\usage{
cBivariateGumbel(u1, u2, dependencyParameter, ...)

cdBivariateGumbel(u1, u2, dependencyParameter, ...)

crBivariateGumbel(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cBivariateGumbel}}  returns the value of the copula.
    \item \code{\link{cdBivariateGumbel}}  returns the value of the density function associated to the copula.
    \item \code{\link{crBivariateGumbel}}  returns simulated values of the copula.
  }
}
\description{
Computes CDF, PDF and simulations of the bivariate Gumbel copula.
}
\details{
The bivariate Gumbel copula has CDF :
}
\examples{
cBivariateGumbel(u1 = .76, u2 = 0.4, dependencyParameter = 1.4)

cdBivariateGumbel(u1 = .76, u2 = 0.4, dependencyParameter = 1.4)

crBivariateGumbel(numberSimulations = 10, seed = 42, dependencyParameter = 1.2)

}
