\name{zwl}
\alias{zwl}
\title{High-Dimensional Two-Sample Mean Test with Centering Adjustment}
\description{
  Conducts a high-dimensional two-sample mean test with centering adjustment.
  This function is designed for cases where the number of variables \( p \) is larger than the sample sizes \( n \) and \( m \).
}
\usage{
zwl(X, Y, order = 0)
}
\arguments{
  \item{X}{
    Matrix representing the first sample (rows are observations, columns are variables).
  }
  \item{Y}{
    Matrix representing the second sample (rows are observations, columns are variables).
  }
  \item{order}{
    Integer specifying the order of centering adjustment (default is 0).
  }
}
\value{
  A list containing:
  \item{statistic}{The test statistic value.}
  \item{pvalue}{The p-value of the test.}
  \item{Tn}{The adjusted test statistic before centering.}
  \item{var}{The estimated variance.}
}
\details{
  This function performs a high-dimensional two-sample mean test by adjusting the test statistic for centering.
  It uses a modified t-statistic and estimates the variance to handle high-dimensional data.
  The function also includes a custom centering adjustment based on the specified order.
}
\examples{
# Example usage:
set.seed(123)
X <- matrix(rnorm(200), nrow = 10, ncol = 20)  # 10 samples, 20 variables
Y <- matrix(rnorm(200, mean = 0.5), nrow = 10, ncol = 20)  # Different mean
result <- zwl(X, Y, order = 0)
print(result)

# Output:
# $statistic: The test statistic value
# $pvalue: The p-value indicating the significance of the test
# $Tn: The adjusted test statistic before centering
# $var: The estimated variance
}
