% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HSESPlot2DCl.R
\name{HSESPlot2DCl}
\alias{HSESPlot2DCl}
\title{Plots historical simulation ES against confidence level}
\usage{
HSESPlot2DCl(Ra, cl)
}
\arguments{
\item{Ra}{Vector of daily P/L data}

\item{cl}{Vector of ES confidence levels}
}
\description{
Function plots the historical simulation ES of a
portfolio against confidence level, for specified range of confidence level
and holding period implied by data frequency.
}
\examples{
# Plots historical simulation ES against confidence level
   Ra <- rnorm(100)
   cl <- seq(.90, .99, .01)
   HSESPlot2DCl(Ra, cl)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

