% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogNormalVaRPlot3D.R
\name{LogNormalVaRPlot3D}
\alias{LogNormalVaRPlot3D}
\title{Plots log normal VaR against confidence level and holding period}
\usage{
LogNormalVaRPlot3D(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 investment Size of investment

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a vector}
}
\description{
Plots the VaR of a portfolio against confidence level and holding period assuming that geometric
 returns are normal distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR against confidene level given geometric return data
   data <- rnorm(5, .09, .03)
   LogNormalVaRPlot3D(returns = data, investment = 5, cl = seq(.9,.99,.01), hp = 1:100)

   # Computes VaR against confidence level given mean and standard deviation of return data
   LogNormalVaRPlot3D(mu = .012, sigma = .03, investment = 5, cl = seq(.9,.99,.01), hp = 1:100)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

