% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalVaRConfidenceInterval.R
\name{NormalVaRConfidenceInterval}
\alias{NormalVaRConfidenceInterval}
\title{Generates Monte Carlo 95\% Confidence Intervals for normal VaR}
\usage{
NormalVaRConfidenceInterval(mu, sigma, number.trials, sample.size, cl, hp)
}
\arguments{
\item{mu}{Mean of the P/L process}

\item{sigma}{Standard deviation of the P/L process}

\item{number.trials}{Number of trials used in the simulations}

\item{sample.size}{Sample drawn in each trial}

\item{cl}{Confidence Level}

\item{hp}{Holding Period}
}
\value{
95\% confidence intervals for normal VaR
}
\description{
Generates 95\% confidence intervals for normal VaR using Monte Carlo simulation
}
\examples{
# Generates 95\\\% confidence intervals for normal VaR for given parameters
   NormalVaRConfidenceInterval(0, .5, 20, 15, .95, 90)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

