% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VarianceCovarianceVaR.R
\name{VarianceCovarianceVaR}
\alias{VarianceCovarianceVaR}
\title{Variance-covariance VaR for normally distributed returns}
\usage{
VarianceCovarianceVaR(vc.matrix, mu, positions, cl, hp)
}
\arguments{
\item{vc.matrix}{Assumed variance covariance matrix for returns}

\item{mu}{Vector of expected position returns}

\item{positions}{Vector of positions}

\item{cl}{Confidence level and is scalar or vector}

\item{hp}{Holding period and is scalar or vector}
}
\description{
Estimates the variance-covariance VaR of a
portfolio assuming individual asset returns are normally distributed,
for specified confidence level and holding period.
}
\examples{
# Variance-covariance VaR for randomly generated portfolio
   vc.matrix <- matrix(rnorm(16),4,4)
   mu <- rnorm(4)
   positions <- c(5,2,6,10)
   cl <- .95
   hp <- 280
   VarianceCovarianceVaR(vc.matrix, mu, positions, cl, hp)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}
\seealso{
AdjustedVarianceCovarianceVaR
}

