% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pattern_long_1d.R
\name{estimate_pattern_long_1d}
\alias{estimate_pattern_long_1d}
\title{Estimate the Regular Longitudinal Pattern of Univariate Data}
\usage{
estimate_pattern_long_1d(
  data_matrix,
  time_matrix,
  nobs,
  design_interval,
  n_time_units,
  time_unit,
  estimation_method,
  smoothing_method = "local linear",
  bw_mean,
  bw_var,
  bw_cov,
  bw_t,
  bw_y
)
}
\arguments{
\item{data_matrix}{observed data arranged in a numeric matrix format. \cr
\code{data_matrix[i,j]} is the jth observation of the kth dimension of the ith subject.}

\item{time_matrix}{observation times arranged in a numeric matrix format. \cr
\code{time_matrix[i,j]} is the jth observation time of the ith subject. \cr
\code{data_matrix[i,j]} is observed at \code{time_matrix[i,j]}.}

\item{nobs}{number of observations arranged as an integer vector. \cr
\code{nobs[i]} is the number of observations for the ith subject.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{estimation_method}{a character specifying the estimation method. \cr
If \code{estimation_method="meanvar"}, the function will estimate 
the mean and variance functions using local smoothing
(c.f., Qiu and Xiang, 2014). 
Parameters \code{bw_mean} and \code{bw_var} are required. \cr
If \code{estimation_method="meanvarcov"}, the function will estimate 
the mean, variance and covariance functions using local smoothing 
(c.f., Li and Qiu, 2016). 
Parameters \code{bw_mean}, \code{bw_var} and \code{bw_cov} are required. \cr
If \code{estimation_method="meanvarcovmean"}, the function will estimate
the mean, variance and covariance functions (c.f., Li and Qiu, 2016).
In the last step, the mean function will be updated using the
covariance function. 
Parameters \code{bw_mean}, \code{bw_var} and \code{bw_cov} are required. \cr
If \code{estimation_method="distribution"}, the function will estimate the 
distribution function (c.f., You and Qiu, 2020).
Parameters \code{bw_t} and \code{bw_y} are required. \cr
If \code{estimation_method="distributionvarcov"}, the function will estimate the 
distribution function and the covariance function of standardized values
(c.f., You and Qiu 2020).
Parameters \code{bw_cov}, \code{bw_t} and \code{bw_y} are required.}

\item{smoothing_method}{a character value specifying the smoothing method. \cr
If \code{smoothing_method="local constant"}, apply local constant approximation. \cr
If \code{smoothing_method="local linear"}, apply local linear approximation.}

\item{bw_mean}{a numeric value. \cr
The bandwidth parameter for estimating mean function.}

\item{bw_var}{a numeric value. \cr
The bandwidth parameter for estimating variance function.}

\item{bw_cov}{a numeric value. \cr
The bandwidth parameter for estimating covariance function.}

\item{bw_t}{a numeric value. \cr
The bandwidth parameter in time axis for estimating distribution function.}

\item{bw_y}{a numeric value. \cr
The bandwidth parameter in y-axis for estimating distribution function.}
}
\value{
a list that stores the estimated longitudinal pattern and model parameters. \cr
If \code{estimation_method="meanvar"}, returns a list of class \code{pattern_long_1d_meanvar} \cr
If \code{estimation_method="meanvarcov"} or \code{"meanvarcovmean"}, returns a list of class \code{pattern_long_1d_meanvarcov} \cr
If \code{estimation_method="distribution"}, returns a list of class \code{pattern_long_1d_distribution} \cr
If \code{estimation_method="distributionvarcov"}, returns a list of class \code{pattern_long_1d_distributionvarcov} \cr
\item{$grid}{Discretized design interval.}
\item{$mean_est}{Estimated mean function.}
\item{$var_est}{Estimated variance function.}
\item{$cov_est}{Estimated covariance function.}
}
\description{
Function \code{estimate_pattern_long_1d} estimate the regular longitudinal pattern 
of a univariate variable from a dataset of n subjects. This is usually the first step of dynamic screening.
The pattern can be described by mean, variance, covariance, and distribution depending on the estimation method. 
When the estimated pattern is used for monitoring new subjects, the collected data from new subjects are 
compared to the estimated pattern for monitoring abnormality.
}
\details{
Estimate the Regular Longitudinal Pattern of Univariate Data
}
\examples{
data("data_example_long_1d")

result_pattern<-estimate_pattern_long_1d(
  data_matrix=data_example_long_1d$data_matrix_IC,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  estimation_method="meanvar",
  smoothing_method="local linear",
  bw_mean=0.1,
  bw_var=0.1)
}
\references{
Qiu, P. and Xiang, D. (2014). Univariate dynamic screening system: an approach for identifying individuals with irregular longitudinal behavior. Technometrics, 56:248-260. \cr
Li, J. and Qiu, P. (2016). Nonparametric dynamic screening system for monitoring correlated longitudinal data. IIE Transactions, 48(8):772-786. \cr
You, L. and Qiu, P. (2019). Fast computing for dynamic screening systems when analyzing correlated data. Journal of Statistical Computation and Simulation, 89(3):379-394. \cr
You, L., Qiu, A., Huang, B., and Qiu, P. (2020). Early detection of severe juvenile idiopathic arthritis by sequential monitoring of patients' health-related quality of life scores. Biometrical Journal, 62(5). \cr
You, L. and Qiu, P. (2021). A robust dynamic screening system by estimation of the longitudinal data distribution. Journal of Quality Technology, 53(4).
}
