% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebase_prep.R
\name{ebase_prep}
\alias{ebase_prep}
\title{Prepare data for ebase}
\usage{
ebase_prep(dat, Z, interval, ndays = 1)
}
\arguments{
\item{dat}{input data frame}

\item{Z}{numeric as single value for water column depth (m) or vector equal in length to number of rows in \code{dat}}

\item{interval}{timestep interval in seconds}

\item{ndays}{numeric for number of days in \code{dat} for optimizing the metabolic equation, see details}
}
\value{
A data frame with additional columns required for \code{\link{ebase}}. Dissolved oxygen as a volumetric concentration in \code{dat} as mg/L is returned in areal units as mmol/m2. If multiple time steps are identified, the number of rows in data frame is expanded based on the time step define by \code{interval}.  Numeric values in the expanded rows will be interpolated if \code{interp = TRUE}, otherwise they will remain as \code{NA} values.
}
\description{
Prepare data for ebase
}
\details{
Checks if all columns are present by matching those in \code{\link{exdat}}, checks if \code{DateTimeStamp} is in ascending order, converts dissolved oxygen from mg/L to mmol/m3, calculates the Schmidt number (unitless) from water temp (C) and salinity (psu), and calculates dissolved oxygen equilibrium concentration (mmol/m3) from salinity and temperature

The \code{ndays} argument defines the number of days that are used for optimizing the above mass balance equation.  By default, this is done each day, i.e., \code{ndays= 1} such that a loop is used that applies the model equation to observations within each day, evaluated iteratively from the first observation in a day to the last.  Individual parameter estimates for \emph{a}, \emph{R}, and \emph{b} are then returned for each day.  However, more days can be used to estimate the unknown parameters, such that the loop can be evaluated for every \code{ndays} specified by the argument.  The \code{ndays} argument will separate the input data into groups of consecutive days, where each group has a total number of days equal to \code{ndays}.  The final block may not include the complete number of days specified by \code{ndays} if the number of unique dates in the input data includes a remainder when divided by \code{ndays}, e.g., if seven days are in the input data and \code{ndays = 5}, there will be two groups where the first has five days and the second has two days. The output data from \code{\link{ebase}} includes a column that specifies the grouping that was used based on \code{ndays}.

Missing values are interpolated at the interval specified by the \code{interval} argument for conformance with the core model equation. Records at the start or end of the input time series that do not include a full day are also removed.  A warning is returned to the console if gaps are found or dangling records are found.
}
\examples{
dat <- ebase_prep(exdat, Z = 1.85, interval = 900)
head(dat)
}
