% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_LS.R
\name{density_LS}
\alias{density_LS}
\title{log-density derivatives--parametric approach}
\usage{
density_LS(x)
}
\arguments{
\item{x}{a sequence of chi-squared test statistics}
}
\value{
a list: the first-to-fourth log density derivatives
}
\description{
Assuming the log density of the chi-squared statistics admits a parametric form, this function
estimates up to the fourth order log density derivatives.
}
\examples{
p = 1000
k = 7
# the prior distribution for lambda
alpha = 2
beta =  10
# lambda
lambda = rep(0, p)
pi_0 = 0.8
p_0 = floor(p*pi_0)
p_1 = p-p_0
lambda[(p_0+1):p] = stats::rgamma(p_1, shape = alpha, rate=1/beta)
# Generate a Poisson RV
J = sapply(1:p, function(x){rpois(1, lambda[x]/2)})
X = sapply(1:p, function(x){rchisq(1, k+2*J[x])})
out = density_LS(X)

}
