% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_reservation.R
\name{create_reservation}
\alias{create_reservation}
\title{Create reservation}
\usage{
create_reservation(scope, env = "production")
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Identifier of reserved data package
}
\description{
Reserves the next available identifier for the specified scope
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create reservation
identifier <- create_reservation(scope = "edi", env = "staging")
identifier
#> [1] 604

# Delete reservation
delete_reservation(scope = "edi", identifier = identifier, env = "staging")
#> [1] 604

logout()
}

}
\seealso{
Other Identifier Reservations: 
\code{\link{delete_reservation}()},
\code{\link{list_active_reservations}()},
\code{\link{list_reservation_identifiers}()}
}
\concept{Identifier Reservations}
