% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall.R
\name{waterfall}
\alias{waterfall}
\title{Explain prediction of a single observation}
\usage{
waterfall(
  xgb_model,
  new_observation,
  data,
  type = "binary",
  option = "interactions",
  baseline = 0
)
}
\arguments{
\item{xgb_model}{a xgboost model.}

\item{new_observation}{a new observation.}

\item{data}{row from the original dataset with the new observation to explain (not one-hot-encoded).
The param above has to be set to merge categorical features.
If you dont wont to merge categorical features, set this parameter the same as \code{new_observation}.}

\item{type}{the learning task of the model. Available tasks: "binary" for binary classification  or "regression" for linear regression.}

\item{option}{if "variables", the plot includes only single variables,
if "interactions", then only interactions.
Default "interaction".}

\item{baseline}{a number or a character "Intercept" (for model intercept).
The baseline for the plot, where the rectangles should start.
Default 0.}
}
\value{
an object of the broken class
}
\description{
This function calculates a table with influence of variables and interactions
on the prediction of a given observation. It supports only xgboost models.
}
\details{
The function contains code or pieces of code
from \code{breakDown} code created by Przemysław Biecek
and \code{xgboostExplainer} code created by David Foster.
}
\examples{

\donttest{
library("EIX")
library("Matrix")
sm <- sparse.model.matrix(left ~ . - 1,  data = HR_data)

library("xgboost")
param <- list(objective = "binary:logistic", max_depth = 2)
xgb_model <- xgboost(sm, params = param, label = HR_data[, left] == 1, nrounds = 25, verbose=0)

data <- HR_data[9,-7]
new_observation <- sm[9,]

wf <- waterfall(xgb_model, new_observation, data,  option = "interactions")
wf

plot(wf)
}

}
