% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.l.R
\name{get.l}
\alias{get.l}
\title{Generate a vector of weight transformation values from l.min to l.max.}
\usage{
get.l(X, n = 10, max = 0.95, min = 0)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{n}{\code{Numeric} scalar, length of the output vector (by default 10).}

\item{max}{\code{Numeric} scalar, fraction of the maximum value 
(by default 0.95).}

\item{min}{\code{Numeric} scalar, minimum value (by default zero).}
}
\value{
\code{Numeric} vector of class \code{"EMMAgeo_l"}, weight 
transformation values.
}
\description{
This function generates a sequence of weight transformation values that
range from l_min (by default zero) to l_max (by default 95 \% of the 
maximum possible value). It uses the function \code{test.l.max()}.
}
\examples{

## load example data set
data(example_X)

## truncate data set to save computation time, not needed in real life
X <- X[1:10, 1:10]

## infer l-vector
l <- get.l(X = X, 
           n = 5, 
           max = 0.8, 
           min = 0.02)

}
\seealso{
\code{test.l.max}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
