% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic.R
\name{bic}
\alias{bic}
\title{Computes the Bayesian Information Criterion}
\usage{
bic(mod)
}
\arguments{
\item{mod}{A fitted model of class \code{lm} or \code{merMod}.}
}
\description{
Computes the Bayesian Information Criterion of a model (Schwarz, 1978).
}
\examples{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
bic(mod1)

}
\references{
Schwarz, G. (1978). Estimating the dimension of a model.
Annals of Statistics, 6, 461-464.
}
\seealso{
\code{\link{aic}}, \code{\link{ictab}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
