% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ensemble.R
\name{fit_ensemble_model}
\alias{fit_ensemble_model}
\title{Fits the ensemble model}
\usage{
fit_ensemble_model(
  observations,
  simulators,
  priors,
  full_sample = TRUE,
  control = list(adapt_delta = 0.95),
  drivers = FALSE,
  MMod,
  ...
)
}
\arguments{
\item{observations}{A \code{list} of length 2 containing observations and a covariance matrix. The first element is a \code{data.frame} or \code{matrix} with each column giving observations of each output of interest and each row a time. Rows should be named with the times and columns should be named the variables. The second element is is a \eqn{d \times d} \code{matrix} where \eqn{d} is the number of columns of the observations data frame / matrix. This matrix is the covariance matrix of the observations.}

\item{simulators}{A \code{list} with length equal to the number of simulators. For each simulator, there is a \code{list} of 2 objects containing the simulator output and covariance matrix. The first element is a \code{data.frame} or \code{matrix} with each column giving a simulator outputs of interest and each row a time. Rows should be named with the times and columns should be named the variables. The second element is a \eqn{n_k \times n_k} \code{matrix} where \eqn{n_k} is the number of columns of the simulators output data frame / matrix. This matrix is the covariance matrix of the simulator outputs.}

\item{priors}{An \code{EnsemblePrior} object specifying the prior distributions for the ensemble.}

\item{full_sample}{A \code{logical} that runs a full sampling of the posterior density of the ensemble model if \code{TRUE}. If \code{FALSE}, returns the point estimate which maximises the posterior density of the ensemble model.}

\item{control}{If creating a full sample, this is a named \code{list} of paramaters to control Stan's sampling behaviour. See the documentation of the \code{stan()} function in the \code{rstan} package for details. The default value is \code{list(adapt_delta = 0.95)}. If optimizing, this value is ignored.}

\item{drivers}{A \code{logical} indicating whether drivers have been used in combination with simulators. Default value is FALSE.}

\item{MMod}{Not currently implemented.}

\item{...}{Additional arguments passed to the function \code{rstan::sampling} or  \code{rstan::optimizing}.}
}
\value{
An \code{EnsembleFit} object.
}
\description{
\code{fit_ensemble_model} runs an MCMC of the ensemble model. This process can take a long time depending on the size of the datasets.
}
\examples{
\donttest{

fit <- fit_ensemble_model(observations = list(SSB_obs, Sigma_obs),
               simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                 list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                 list(SSB_lm,  Sigma_lm, "LeMans"),
                                 list(SSB_miz, Sigma_miz, "Mizer")),
               priors = EnsemblePrior(4,
               ind_st_params = IndSTPrior(parametrisation_form = "lkj",
               var_params= list(1,1), cor_params = 10, AR_params = c(2, 2))),
               full_sample = FALSE) #Only optimise in this case
}
}
\references{
Stan Development Team (2020). RStan: the R interface to Stan. R package version 2.21.2. https://mc-stan.org
}
\seealso{
\code{\linkS4class{EnsembleFit}}, \code{\link{EnsembleSample}}
}
