% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Faa_di_Bruno.R
\name{vectorized_Faa_di_Bruno}
\alias{vectorized_Faa_di_Bruno}
\title{Vectorized version of Faa di Bruno formula}
\usage{
vectorized_Faa_di_Bruno(f, g, x, k, args_f, args_g)
}
\arguments{
\item{f, g}{two functions that take in argument\itemize{
\item a vector \code{x} of numeric values
\item an integer \code{k} which is as to be understood
as the order of the derivative of f
\item potentially other parameters (not vectorized)
}}

\item{x}{vector of (one-dimensional) values
at which the \code{k}-th order derivatives is to be evaluated.}

\item{k}{the order of the derivative}

\item{args_f, args_g}{the list of additional parameters to be passed on
to \code{f} and \code{g}. This must be the same for all values of \code{x}.}
}
\value{
a vector of size \code{length(x)} for which
the \code{i}-th component is
\eqn{(f \circ g)^{(k)} (x[i])}
}
\description{
This code implements a vectorized version of the Faa di Bruno formula, relying
internally on the Bell polynomials from the package kStatistics, via the
function \link[kStatistics:eBellPol]{kStatistics::eBellPol}.
}
\examples{
g <- function(x, k, a){
  if (k == 0){ return ( exp(x) + a)
  } else {
    return (exp(x))
  }
}
args_g = list(a = 2)

f <- function(x, k, a){
  if (k == 0){ return ( x^2 + a)
  } else if (k == 1) {
    return ( 2 * x)
  } else if (k == 2) {
    return ( 2 )
  } else {
    return ( 0 )
  }
}
args_f = list(a = 5)

x = 1:5
vectorized_Faa_di_Bruno(f = f, g = g, x = x, k = 1,
  args_f = args_f, args_g = args_g)
# Derivative of ( exp(x) + 2 )^2 + 5
# which explicit expression is:
2 * exp(x) * ( exp(x) + 2 )

}
\seealso{
\code{\link{compute_matrix_alpha}} which also uses the Bell polynomials
in a similar way.
}
\author{
Alexis Derumigny, Victor Ryan
}
