% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRScaledAdditiveNoise.R
\name{SIRScaledAdditiveNoise}
\alias{SIRScaledAdditiveNoise}
\title{SIR model with Scaled additive noise (P 6.2).}
\usage{
SIRScaledAdditiveNoise(pars = NULL, init = NULL, time = NULL, ...)
}
\arguments{
\item{pars}{\code{\link{vector}} with 5 parameters: transmission rate, recovery rate, per capita death rate, the total population size and the number of steps that will change noise term. The names of these values must be "beta", "gamma", "mu", "N" and "step", respectively. All parameters must be positive and all rates are specified in days. The birth rate is assumed to be constant and equal to mu * N, therefore preventing extinction of the host population. Noise terms are generated as a function of the time step and its magnitude is a function of the rate of each process.}

\item{init}{\code{\link{vector}} with 2 values: the initial population size that are susceptible and infectious. The names of these values must be "X" and "Y", respectively. All initial conditions must be positive.}

\item{time}{time sequence for which output is wanted; the first value of times must be the initial time.}

\item{...}{further arguments passed to \link[deSolve]{ode} function.}
}
\value{
\code{\link{list}}. The first element, \code{*$model}, is the model function. The second, third and fourth elements are the vectors (\code{*$pars}, \code{*$init}, \code{*$time}, containing the \code{pars}, \code{init} and \code{time} arguments of the function. The fifth element \code{*$results} is a \code{\link{data.frame}} with up to as many rows as elements in time. First column contains the time. The following columns contain the proportion of susceptibles, infectious and recovered.
}
\description{
Solves a SIR model with scaled additive noise.
}
\details{
This is the R version of program 6.2 from page 197 of "Modeling Infectious Disease in humans and animals" by Keeling & Rohani.
}
\examples{
# Parameters and initial conditions.
parameters <- c(beta = 1, gamma = 1 / 10, mu = 1 / (50 * 365),
                N = 1e6, step = 1)
initials <- c(X = 1e5, Y = 500)

# Solve and plot.
sir.scaled.additive.noise <- 
SIRScaledAdditiveNoise(pars = parameters, 
                       init = initials, time = 5 * 365)
PlotMods(sir.scaled.additive.noise)

}
\references{
Keeling, Matt J., and Pejman Rohani. Modeling infectious diseases in humans and animals. Princeton University Press, 2008.
}
\seealso{
\link[deSolve]{ode}.
}
