% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcm.inputs.R
\name{init.dcm}
\alias{init.dcm}
\title{Initial Conditions for Deterministic Compartmental Models}
\usage{
init.dcm(s.num, i.num, r.num, s.num.g2, i.num.g2, r.num.g2, ...)
}
\arguments{
\item{s.num}{Number of initial susceptible persons. For two-group models,
this is the number of initial group 1 susceptible persons.}

\item{i.num}{Number of initial infected persons. For two-group models, this
is the number of initial group 1 infected persons.}

\item{r.num}{Number of initial recovered persons. For two-group models, this
is the number of initial group 1 recovered persons. This parameter is
only used for the \code{SIR} model type.}

\item{s.num.g2}{Number of initial susceptible persons in group 2. This
parameter is only used for two-group models.}

\item{i.num.g2}{Number of initial infected persons in group 2. This parameter
is only used for two-group models.}

\item{r.num.g2}{Number of initial recovered persons in group 2. This
parameter is only used for two-group \code{SIR} models.}

\item{...}{Additional initial conditions passed to model.}
}
\value{
An \code{EpiModel} object of class \code{init.dcm}.
}
\description{
Sets the initial conditions for deterministic compartmental
models simulated with \code{dcm}.
}
\details{
The initial conditions for a model solved with \code{\link{dcm}} should be
input into the \code{init.dcm} function. This function handles initial
conditions for both base model types and original models.

Original models may use the parameter names listed as arguments here, a new
set of names, or a combination of both. With new models, initial conditions
must be input in the same order that the solved derivatives from the model
are output.
}
\seealso{
Use \code{\link{param.dcm}} to specify model parameters and
\code{\link{control.dcm}} to specify the control settings. Run the
parameterized model with \code{\link{dcm}}.
}
\keyword{parameterization}
