% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{delay_opts}
\alias{delay_opts}
\title{Delay Distribution Options}
\usage{
delay_opts(dist = Fixed(0), default_cdf_cutoff = 0.001, weight_prior = TRUE)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions. Default is
a fixed distribution with all mass at 0, i.e. no delay.}

\item{default_cdf_cutoff}{Numeric; default CDF cutoff to be used if an
unconstrained distribution is passed as \code{dist}. If \code{dist} is already
constrained by having a maximum or CDF cutoff this is ignored. Note that
this can only be done for <dist_spec> objects with fixed parameters.}

\item{weight_prior}{Logical; if TRUE (default), any priors given in \code{dist}
will be weighted by the number of observation data points, in doing so
approximately placing an independent prior at each time step and usually
preventing the posteriors from shifting. If FALSE, no weight
will be applied, i.e. any parameters in \code{dist} will be treated as a single
parameters.}
}
\value{
A \verb{<delay_opts>} object summarising the input delay distributions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns delay distributions formatted for usage by downstream
functions.
}
\examples{
# no delays
delay_opts()

# A single delay that has uncertainty
delay <- LogNormal(
  meanlog = Normal(1, 0.2),
  sdlog = Normal(0.5, 0.1),
  max = 14
)
delay_opts(delay)

# A single delay without uncertainty
delay <- LogNormal(meanlog = 1, sdlog = 0.5, max = 14)
delay_opts(delay)

# Multiple delays (in this case twice the same)
delay_opts(delay + delay)
}
\seealso{
\code{\link[=convert_to_logmean]{convert_to_logmean()}} \code{\link[=convert_to_logsd]{convert_to_logsd()}}
\code{\link[=bootstrapped_dist_fit]{bootstrapped_dist_fit()}} \code{\link{Distributions}}
}
