% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchicalWrapper.R
\name{hierarchicalCluster}
\alias{hierarchicalCluster}
\title{hierarchical clustering}
\usage{
hierarchicalCluster(data = NULL, distmethod = NULL, clusters = NULL, ...)
}
\arguments{
\item{data}{A Data set}

\item{distmethod}{The distance measure to be used. This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{clusters}{The number of Clusters}

\item{\dots}{Additional parameters passed to  hclust function}
}
\value{
A list of cluster labels
}
\description{
This function seeks to build a hierarchy of clusters
}
\examples{
library(datasets)
data(iris)

rndSamples <- sample(nrow(iris),100)
trainData <- iris[rndSamples,]
testData <- iris[-rndSamples,]

cls <- hierarchicalCluster(trainData[,1:4],distmethod="euclidean",clusters=3)
}
