% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILogit.R
\name{ILogit}
\alias{ILogit}
\title{ILogit dynamic}
\usage{
ILogit(time, state, parameters)
}
\arguments{
\item{time}{Regular sequence that represents the time sequence under which
simulation takes place.}

\item{state}{Numeric vector that represents the initial state.}

\item{parameters}{Numeric vector that represents parameters needed by the
dynamic.}
}
\value{
Numeric list. Each component represents the rate of change depending on
 the dynamic.
}
\description{
Imitative Logit dynamic as a type of evolutionary dynamics.
}
\examples{
dynamic <- ILogit
A <- matrix(c(-1, 0, 0, 0, -1, 0, 0, 0, -1), 3, byrow=TRUE)
state <- matrix(c(0.1, 0.2, 0.7, 0.2, 0.7, 0.1, 0.9, 0.05, 0.05), 3, 3, byrow=TRUE)
eta <- 0.7
phaseDiagram3S(A, dynamic, eta, state, TRUE, FALSE)
}
\references{
Weibull, J. W. (1997)
"Evolutionary Game Theory", MIT Press.
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
