% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{lr_cc_dist}
\alias{lr_cc_dist}
\title{Exact LR_cc (and LR_uc) distribution (auto‑select engine)}
\usage{
lr_cc_dist(n, alpha = 0.05, prune_threshold = 1e-15)
}
\arguments{
\item{n}{Integer sample size (\eqn{n \ge 1}).}

\item{alpha}{Exception probability \eqn{\alpha \in (0,1)}.}

\item{prune_threshold}{Probability below which states are pruned by the
dynamic‑programming recursion.}
}
\value{
A named list with elements \code{LR_cc}, \code{prob_cc}, \code{LR_uc},
\code{prob_uc}. The pairs \code{(LR_cc, prob_cc)} and \code{(LR_uc, prob_uc)}
have equal lengths; each probability vector is in \eqn{[0,1]} and sums to 1.
}
\description{
Returns the finite‑sample distribution of Christoffersen’s conditional‑coverage
statistic \eqn{LR_{\mathrm{cc}}}.  The returned list also includes the matching
unconditional‑coverage distribution \eqn{LR_{\mathrm{uc}}}, produced by the same
dynamic‑programming run.
}
\examples{
lr_cc_dist(8, 0.05)
}
