% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombetukey.r
\name{anscombetukey}
\alias{anscombetukey}
\title{Teste de homogeneidade de variancias de Anscombe e Tukey}
\usage{
anscombetukey(
  resp,
  trat,
  bloco,
  glres,
  qmres,
  sqtrat,
  sqbloco,
  residuos,
  valores.ajustados
)
}
\arguments{
\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{bloco}{Vetor numerico ou complexo contendo os blocos.}

\item{glres}{Escalar. Graus de liberdade do residuo.}

\item{qmres}{Escalar. Quadrado medio do residuo.}

\item{sqtrat}{Escalar. Soma de quadrados do tratamento.}

\item{sqbloco}{Escalar. Soma de quadrados de bloco.}

\item{residuos}{Vetor numerico ou complexo contendo os
residuos.}

\item{valores.ajustados}{Vetor numerico ou complexo contendo os
valores ajustados.}
}
\value{
Retorna o valor-p do teste de Anscombe e Tukey de
homogeneidade de variancias para uma hipotese nula de que as
variancias sao homogeneas.
}
\description{
\code{anscombetukey} Realiza o teste de Anscombe e Tukey
(1963) para o teste de homegenidade de variancias em um
delineamento em blocos casualizados.
}
\examples{
data(ex2)
attach(ex2)
dbc(trat, provador, aparencia, quali = TRUE, mcomp = "tukey",
hvar='anscombetukey', sigT = 0.05, sigF = 0.05)
}
\references{
ANSCOMBE, F. J.; TUKEY, J. W. \emph{The
examination and analysis of residuals.} Technometrics,
5:141-160, 1963.

RIBEIRO, R. \emph{Proposta e comparacao do desempenho de
testes para homogeneidade de variancia de modelos de
classificacao one-way e two-way}. Iniciacao Cientifica.
(Iniciacao Cientifica) - Universidade Federal de Alfenas.
2012.
}
\seealso{
\code{\link{han}}, \code{\link{oneilldbc}}.
}
\author{
Eric B Ferreira, \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Marcos Costa de Paula

Mateus Pimenta Siqueira Lima
}
