% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmleFH.R
\name{mmleFH}
\alias{mmleFH}
\title{Marginal MLEs for the Fay-Herriot model}
\usage{
mmleFH(y, X, V, ss0 = 0, df0 = 0)
}
\arguments{
\item{y}{direct data following normal model \eqn{y\sim N(\theta,V\sigma^2)}}

\item{X}{linking model predictors \eqn{ \theta\sim N(X\beta,\tau^2 I)}}

\item{V}{covariance matrix to scale}

\item{ss0}{prior sum of squares for estimate of \eqn{\sigma^2}}

\item{df0}{prior degrees of freedom for estimate of \eqn{\sigma^2}}
}
\value{
a list of parameter estimates including 
\enumerate{
\item beta, the estimated regression coefficients
\item t2, the estimate of \eqn{\tau^2} 
\item s2,  the estimate of \eqn{\sigma^2}
}
}
\description{
Marginal MLEs for the Fay-Herriot random effects model where 
the covariance matrix for the sampling model is known to scale.
}
\examples{
 
n<-30 ; p<-3 
X<-matrix(rnorm(n*p),n,p)  
beta<-rnorm(p) 
theta<-X\%*\%beta + rnorm(n)  
V<-diag(n) 
y<-theta+rnorm(n) 
mmleFH(y,X,V) 

}
\author{
Peter Hoff
}
