% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cev.R
\name{CevMassZero}
\alias{CevMassZero}
\title{Calculate the mass at zero under the CEV model}
\usage{
CevMassZero(
  spot,
  texp = 1,
  sigma,
  beta = 0.5,
  intr = 0,
  divr = 0,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{beta}{beta}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
mass at zero
}
\description{
Calculate the mass at zero under the CEV model
}
\examples{
spot <- 100
texp <- 1.2
beta <- 0.5
sigma <- 2
FER::CevMassZero(spot, texp, sigma, beta)

}
