% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe.prov.R
\name{fe.prov}
\alias{fe.prov}
\title{Fit logistic fixed-effect model with high-dimensional predictors}
\usage{
fe.prov(data, Y.char, Z.char, prov.char, tol = 1e-05, null = "median")
}
\arguments{
\item{data}{prepared \code{data.frame}. Use \code{\link{fe.data.prep}} to prepare the raw data}

\item{Y.char}{name of the response variable from \code{data} as a character string}

\item{Z.char}{names of covariates from \code{data} as vector of character strings}

\item{prov.char}{name of provider IDs variable as a character string}

\item{tol}{tolerance level for convergence. Default is \code{1e-5}}

\item{null}{use median for null comparison}
}
\value{
An object of class \code{fe.prov}, which is just a \code{List} object with the following named elements:
\itemize{
\item \code{beta:} a vector of fixed effect estimates
\item \code{Obs:} a vector of responses for included providers
\item \code{Exp:} a vector of expected probabilities of readmission within 30 days of discharge
\item \code{iter:} number of iterations needed for convergence
\item \code{beta.max.diff:} value of the stopping criterion
\item \code{df.prov:}
}
\code{df.prov} is a \code{data.frame} of provider-level information with the following items:
\itemize{
\item \code{Obs:} provider-level observed number of readmissions within 30 days
\item \code{Exp:} expected number of readmissions within 30 days
\item \code{SRR:} standardized readmission ratios for each hospital
\item \code{gamma:} a vector of provider effect estimates for included hospitals
}
}
\description{
\code{fe.prov} fits a fixed-effect logistic model using structured profile
likelihood algorithm. Standardized readmission ratios (SRRs) are also computed.
Go to \href{https://github.com/umich-biostatistics/FEprovideR}{Github} for
a tutorial.
}
\examples{
# Name input variables and other parameters
# a small positive number specifying stopping
# criterion of Newton-Raphson algorithm
tol <- 1e-5
Y.char <- 'Y'
prov.char <- 'prov.ID'
Z.char <- paste0('z', 1:3)
data(hospital_prepared) # build in data set
fe.ls <- fe.prov(hospital_prepared, Y.char, Z.char, prov.char, tol) # model fitting

}
\references{
He, K., Kalbfleisch, J.D., Li, Y. and Li, Y., 2013. Evaluating hospital
readmission rates in dialysis facilities; adjusting for hospital effects. Lifetime data
analysis, 19(4), pp.490-512.
}
\seealso{
\code{\link{fe.data.prep}},   \code{\link{test.fe.prov}},
\code{\link{funnel.SRR}},   \code{\link{confint.fe.prov}}
}
