% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{margeff_moderators}
\alias{margeff_moderators}
\title{Compute association between moderators and group membership}
\usage{
margeff_moderators(
  object,
  newdata = NULL,
  vcov = TRUE,
  se.method = NULL,
  quant_continuous = c(0.25, 0.75),
  abs_diff = FALSE
)
}
\arguments{
\item{object}{An object from \code{\link{FactorHet}} or
\code{\link{FactorHet_mbo}}.}

\item{newdata}{An optional argument that provides the data over which to
average the distribution of the other moderators. The default is
\code{NULL} which uses the estimation data.}

\item{vcov}{A logical value indicating whether the standard errors should be
computed. The default is \code{TRUE}.}

\item{se.method}{An optional argument as to the type of standard errors used.
The default is \code{NULL} uses estimated standard errors.
\code{\link{vcov.FactorHet}} provides more information.}

\item{quant_continuous}{A numeric vector consisting of two values between 0
and 1. For continuous moderators, it sets two quantiles of the moderator's
distribution to show the difference between. The default \code{c(0.25,
0.75)} compares the effect of changing the moderator from its 25th
percentile to its 75th percentile.}

\item{abs_diff}{A logical value as to whether the difference or absolute
difference in the change in \eqn{\pi_k(X_i)} should be shown. The default
is \code{FALSE} which returns the standard "marginal effect" of changing
the moderators with a standard error computed via the delta method. The
value \code{TRUE} draws 10,000 samples from the asymptotic distribution of
the moderators and computes the average the \bold{absolute values} of the
marginal effects for each observation in \code{newdata} using those
samples. This is considerably slower than the default setting. The appendix
of Goplerud et al. (2025) illustrates one use of this argument.}
}
\value{
Returns a named list with the underlying data (\code{"data"}) and the
  plot (\code{"plot"}).
}
\description{
This function computes the impact of changing a
  moderator on the group membership probabilities.
}
\details{
This function computes the change in \eqn{\pi_k(X_i)} for the change
  in one of the moderators in \eqn{X_i}. The change is averaged across the
  distribution of the other moderators found in \code{newdata} (or, by
  default, the estimation data). It thus can be thought of as the "marginal
  effect" of changing one moderator on the probability of group memberships,
  holding all other moderators constant. It returns a data.frame of the
  estimated effects as well as a plot to visualize the changes in
  \eqn{\pi_k(X_i)}. Goplerud et al. (2025) provides more discussion of this
  method.
}
\examples{
# Estimate model with arbitrary choice of lambda
data(immigration)
set.seed(15)
# Estimate model with arbitrary choice of lambda
fit <- FactorHet(Chosen_Immigrant ~ Plans + Ed + Country,
  design = immigration, lambda = 1e-2,
  moderator = ~ party_ID,
  K = 2, group = ~ CaseID,
  control = FactorHet_control(init = 'mclust'),
  task = ~ contest_no, choice_order = ~ choice_id)
margeff_moderators(fit)
}
