% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{sample_variogram}
\alias{sample_variogram}
\title{Sample variogram}
\usage{
sample_variogram(df, effect, min.np = 30)
}
\arguments{
\item{df}{A data frame with the columns 'col', 'row', and the effects to be plotted.}

\item{effect}{The name of the effects to be plotted.}

\item{min.np}{Minimum number of pairs for which semivariances are displayed (default is 30).}
}
\value{
A sample variogram with x- and y-axes displaying the row and
  column displacements, and the z-axis displaying the average semivariances (variogram ordinates)
  for the effects.
}
\description{
Creates a sample variogram for a set of effects (e.g., plot errors).
}
\examples{
# Sample variogram of plot errors simulated using a separable first order
# autoregressive (AR1) process.

error_df <- field_trial_error(
  ntraits = 1,
  nenvs = 1,
  spatial.model = "AR1"
)

variogram <- sample_variogram(
  df = error_df,
  effect = "e.Trait1"
)

# Sample variogram
variogram

# Extract the data frame with the column and row displacements, and the
# average semivariances.
variogram_df <- variogram$data

}
