% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_methods.R
\name{FF-comparison-methods}
\alias{FF-comparison-methods}
\alias{duplicated,financial_matrix,logical-method}
\alias{unique,financial_matrix,logical-method}
\title{Basic method to check to compare values in a \code{financial_matrix} object}
\usage{
\S4method{duplicated}{financial_matrix,logical}(x, incomparables = FALSE, ...)

\S4method{unique}{financial_matrix,logical}(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{The \code{financial_matrix} object to operate on}

\item{incomparables}{Either:
\itemize{
 \item a vector of values that cannot be compared
 \item or \code{FALSE}, in which case all values can be compared
}}

\item{...}{Arguments passed to the relevant \code{matrix} method}
}
\value{
\itemize{
 \item \code{duplicated}: A logical array with the same dimensions and \code{dimnames} of the \code{financial_matrix}'s matrix component.
 \item \code{unique}: The matrix component is coerced into a vector and then returned, but with only one copy of each duplicated element.
}
}
\description{
Basic method to check to compare values in a \code{financial_matrix} object
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
