% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_both.R
\name{FF.norm.both}
\alias{FF.norm.both}
\title{Create a complete normalised-valued firm-firm (FF) matrix}
\usage{
FF.norm.both(
  ...,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE,
  combining = "sum"
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}

\item{combining}{How to combine the FF matrix for managers and that for owners. Possible values:
\itemize{
 \item \code{sum};
 \item \code{mean} or \code{average};
 \item \code{min};
 \item \code{max};
 }}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a normalised-valued firm-firm (FF) matrix based on both common ownership and board interlocks
}
\details{
The ties' value will reflect the count of common owners and membership depending on \code{combining}:
 -\code{sum}: sum of the shares (normalised on 2);
 -\code{mean} or \code{average}: average of the shares (normalised on 1);
 -\code{min}: minimum of the shares (normalised on 1);
 -\code{max}: maximum of the shares (normalised on 1).
}
\examples{

# Create the complete normalised firm-firm matrix for the companies held by Berkshire Hathaway
data('firms_BKB')
FF <- FF.norm.both(firms_BKB)


}
\seealso{
Other Financial_matrix builders: 
\code{\link{FF}()},
\code{\link{FF.binary.both}()},
\code{\link{FF.binary.management}()},
\code{\link{FF.binary.ownership}()},
\code{\link{FF.naive.both}()},
\code{\link{FF.naive.management}()},
\code{\link{FF.naive.ownership}()},
\code{\link{FF.norm.management}()},
\code{\link{FF.norm.ownership}()}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\concept{Financial_matrix builders}
