% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_function.R
\name{FishTaxaMaker}
\alias{FishTaxaMaker}
\title{Generate a list of species
Auxiliary function to obtain taxonomic classification and check the names of species
present in species pool}
\usage{
FishTaxaMaker(data, allow.manual.insert = TRUE)
}
\arguments{
\item{data}{A character vector with species names or a community matrix with species names in columns}

\item{allow.manual.insert}{Logical, if TRUE (default), the user must type the names of Family and Order of species
not found in Fishbase}
}
\value{
List with three elements.\preformatted{- A data frame containing the taxonomic classification of valid species accordingy to Fishbase

- A data frame with three columns containing the name of species (s), the Family (f) and Order (o) that can be used in
   FishPhyloMaker function
   
- A character vector containing all names of species that was not find in Fishbase
}
}
\description{
Generate a list of species
Auxiliary function to obtain taxonomic classification and check the names of species
present in species pool
}
\examples{
 \dontrun{
 data(neotropical_comm)
 data_comm <- neotropical_comm[, -c(1, 2)]
 taxon_data <- FishTaxaMaker(data_comm, allow.manual.insert = TRUE)
 Characidae
 Characiformes
 Characidae
 Characiformes
 Characidae
 Characiformes
 Loricariidae
 Siluriformes
 Characidae
 Characiformes
 Cichlidae
 Cichliformes
 Crenuchidae
 Characiformes
 Gymnotidae
 Gymnotiformes
 Loricariidae
 Siluriformes
 Loricariidae
 Siluriformes
 Loricariidae
 Siluriformes
 Loricariidae
 Siluriformes
 Heptapteridae
 Siluriformes
 Characidae
 Characiformes
 Loricariidae
 Siluriformes
 Characidae
 Characiformes
}


}
