% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbPlot.R
\name{ProbPlot}
\alias{ProbPlot}
\title{Flood Probability Plotting}
\usage{
ProbPlot(
  data_obs,
  probs = NULL,
  PP = NULL,
  dist = NULL,
  T_rp = NULL,
  beta_CL = NULL,
  T_lim = NULL,
  Q_lim = NULL,
  main_title = NULL,
  x_lab = NULL,
  y_lab = NULL,
  Pcol = "black",
  Ppch = 1,
  Pcex = 1,
  Lcol = "blue",
  Lty = 1,
  Lwd = 1.5,
  CPlot = TRUE,
  CLcol = "red",
  CLty = 2,
  CLwd = 1.5,
  QTcol = "green",
  QTpch = 15,
  QTcex = 1.5,
  GumbRV = FALSE,
  P3SkewCheck = TRUE
)
}
\arguments{
\item{data_obs}{A vector, data frame or matrix containing observed data or flood quantiles.}

\item{probs}{Optional. The vector of plotting position probability values corresponding to
the quantiles. If \code{probs = NULL}, then a Weibull plotting position formula is used to calculate
probability values for quantiles.}

\item{PP}{Optional. A character string that represents the plotting position formula used to 
calculate the empirical probability. The formula can be chosen from the list: \code{"Blom"},
\code{"California_1"}, \code{"California_2"}, \code{"Chegodayev"}, \code{"Gringorten"}, 
\code{"Hazen"}, \code{"Tukey"}, and \code{"Weibull"}. If \code{PP = NULL}, then
\code{PP = 'Weibull'}.}

\item{dist}{Optional. A string that represents CDF and it can be 'Norm' for Normal distribution,
'LNorm' for Log-Normal distribution, 'Gumb' for Gumbel distribution, 'Pea3' for Pearson type III
distribution, and 'LPea3' for Log-Pearson type III distribution. If \code{dist = NULL}, then
\code{dist = 'Norm'}.}

\item{T_rp}{Optional. A numeric vector including the return periods of interest for the flood
quantile estimation.}

\item{beta_CL}{Optional. A numeric scalar that represents the confidence level for calculating 
and plotting the confidence limits (bounds). If \code{beta_CL = NULL},
then \code{beta_CL = 0.95}. It means that the significance level is equal to \code{0.05}.}

\item{T_lim}{Optional. A two-member numeric vector including the lower and upper return period
limits determining the horizontal (x) axis range.}

\item{Q_lim}{Optional. A two-member numeric vector including the lower and upper limits
determining the vertical (y) axis range to show quantile values.}

\item{main_title}{Optional. A character string representing the main title of the plot. The default title
denotes the name of the theoretical probability distribution chosen to fit the data.}

\item{x_lab}{Optional. A character string representing the label of horizontal axis. The default label of
the axis is \code{F(x) = P(X <= x)}.}

\item{y_lab}{Optional. A character string representing the label of vertical axis. The default label of
the axis is \code{"Quantile"}.}

\item{Pcol}{Optional. A specification for the observed flood quantile points color. Defaults to
\code{"black"}.}

\item{Ppch}{Optional. Either an integer specifying a symbol or a single character to be used as
the default in plotting observed flood quantile points. See \code{points} for possible values and
their interpretation. Defaults to 1.}

\item{Pcex}{Optional. A numerical value giving the amount by which plotting point symbols should 
be magnified relative to the default. Defaults to 1.}

\item{Lcol}{Optional. A specification for the theoretical probability line color. Defaults to \code{"blue"}.}

\item{Lty}{Optional. The theoretical probability line type. Line types can either be specified as an
integer (0=blank, 1=solid (default), 2=dashed, 3=dotted, 4=dotdash, 5=longdash, 6=twodash) 
or as one of the character strings \code{"blank"}, \code{"solid"}, \code{"dashed"}, \code{"dotted"},
\code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}, where \code{"blank"} uses
'invisible lines' (i.e., does not draw them). Defaults to 1.}

\item{Lwd}{Optional. The theoretical probability line width, a positive number, defaulting to 1.5.}

\item{CPlot}{Logical. If \code{CPlot = TRUE}, the confidence limits (bounds) are plotted. Defaults to \code{TRUE}.}

\item{CLcol}{Optional. A specification for the confidence limits (bounds) color. Defaults to \code{"red"}.}

\item{CLty}{Optional. The confidence limits (bounds) line type. Line types can either be specified as an
integer (0=blank, 1=solid (default), 2=dashed, 3=dotted, 4=dotdash, 5=longdash, 6=twodash) 
or as one of the character strings \code{"blank"}, \code{"solid"}, \code{"dashed"}, \code{"dotted"},
\code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}, where \code{"blank"} uses
'invisible lines' (i.e., does not draw them). Defaults to 1.}

\item{CLwd}{Optional. The confidence limits (bounds) line width, a positive number, defaulting to 1.5.}

\item{QTcol}{Optional. A specification for the T-year flood quantile estimate point color. Defaults to
\code{"green"}.}

\item{QTpch}{Optional. Either an integer specifying a symbol or a single character to be used as
the default in plotting the T-year flood quantile estimate points. See \code{points} for possible
values and their interpretation. Defaults to 15.}

\item{QTcex}{Optional. A numerical value giving the amount by which the T-year flood quantile
estimate point symbols should be magnified. Defaults to 1.5.}

\item{GumbRV}{Logical. If \code{dist = 'Gumb'} and \code{GumbRV = 'TRUE'}, an extra horizontal
axis is plotted to show Reduced Variable values.}

\item{P3SkewCheck}{Logical. If \code{P3SkewCheck = 'TRUE'} (default), the skewness of data is checked and
if the coefficient of skewness is greater than 2.5, the confidence limits are not plotted for some data in the
left tail of the dataset.}
}
\value{
The function returns a graph including the plotted flood data and the fitted distribution
   and the confidence limits (bounds). Also, it returns and shows the flood quantile estimates 
   corresponding to the return period(s) \code{T_rp}.
}
\description{
\code{ProbPlot} checks that a probability distribution fits a set of flood data.
}
\details{
This is a function for frequency analysis by a graphical method. The flood data are plotted on 
   an appropriate probability paper that linearizes the cumulative distribution function. Then the
   plotted flood data are fitted with a straight line for interpolation and extrapolation purposes.
   If \code{probs = NULL}, then a Weibull plotting position formula is used to calculate probability
   values for quantiles. If \code{PP = NULL}, then a Weibull plotting position formula is used to
   calculate the probabilities corresponding to the quantiles. If \code{dist = NULL}, then Normal
   distribution is used as the default frequency distribution. It should be noted that the distribution
   parameters are estimated by Method Of Moments (MOM). If \code{beta_CL = NULL}, then the
   confidence level is considered equal to 0.95 (that means the significance level is equal to 1-0.95=0.05).
}
\examples{
# First Example
data('Harricana')
ProbPlot(data_obs = Harricana, PP = 'Cunnane', dist = 'LPea3', T_rp = c(100, 1000))

# Second Example
data('AH_Tab12_1_1')
ProbPlot(data_obs = AH_Tab12_1_1, PP = 'Weibull', dist = 'Gumb', T_rp = 250, T_lim = c(2, 1000))

}
\seealso{
\code{\link{PlotPos}} for the plotting position probability.
}
