% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPgvf.R
\name{SNPgvf}
\alias{SNPgvf}
\title{Transform the sequence (genotypes) data into the genetic variant function}
\usage{
SNPgvf(location, X, type, nbasis, params, Plot = FALSE)
}
\arguments{
\item{location}{a numeric vector defining the sampling sites of the sequence data.}

\item{X}{a matrix specifyinging the sequence data, with the number of rows equal to the number of samples.}

\item{type}{a character specifying the type of the basis functions. The options are "Bspline", "Exponential", "Fourier", "Monomial", and "Power".}

\item{nbasis}{an integer specifying the number of basis functions.}

\item{params}{in addition to rangeval (a vector of length 2 giving the lower and upper limits of the range of permissible values for the function) and nbasis, all bases have one or two parameters unique to that basis type or shared with one other:
\itemize{
\item{bspline:}{ Argument norder = the order of the spline, which is one more than the degree of the polynomials used. This defaults to 4, which gives cubic splines.}
\item{exponential:}{ Argument ratevec. In fda_2.0.2, this defaulted to 1. In fda_2.0.3, it will default to 0:1.}
\item{fourier:}{ Argument period defaults to diff(rangeval).}
\item{monomial/power:}{ Argument exponents. Default = 0:(nbasis-1). For monomial bases, exponents must be distinct nonnegative integers. For power bases, they must be distinct real numbers.}
}}

\item{Plot}{should the estimated genetic variant function X(t) be plotted (TRUE) or not (default = FALSE).}
}
\value{
An 'fd' object that contains the estimated genetic variant function.
}
\description{
This function conducts the ordinary linear square smoothing analysis and models the genotypes of an individual (such as the sequence data generated by simX containing only 0, 1, 2) as the genetic variant function X(t).
}
\examples{
library(FunctanSNP)
n <- 20
m <- 50
simdata <- simX(n, m, seed = 1, d.ratio = 0)
X <- simdata$X
location <- simdata$location
SNPgvfres <- SNPgvf(location, X, type = "Bspline", nbasis = 5, params = 4, Plot = FALSE)
plotRawdata(location, X)
plotGVF(SNPgvfres)

}
\seealso{
See Also as \code{\link{simX}}, \code{\link{plotRawdata}}.
}
