% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_calibration_wavelets.R
\name{Bayesian_Shrinkage}
\alias{Bayesian_Shrinkage}
\title{Bayesian Shrinkage}
\usage{
Bayesian_Shrinkage(d, tau, p, sigma, MC = FALSE)
}
\arguments{
\item{d}{Numeric value of the empirical coefficient to be denoised.}

\item{tau}{Numeric value of \eqn{\tau}.}

\item{p}{Numeric value of \eqn{p}.}

\item{sigma}{Numeric value of \eqn{\sigma}.}

\item{MC}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating if the integrals will be approximated using Monte Carlo.}
}
\value{
A numeric value representing the result of the Bayesian shrinkage applied to the empirical coefficient \eqn{d}.
}
\description{
A Bayesian shrinkage method applied to empirical coefficients \eqn{d}, aiming to denoise them.

The shrinkage function is defined as:
\deqn{\delta(d) = \displaystyle \frac{(1 - p) \int_{\mathbb{R}} (\sigma u + d) \, g(\sigma u + d; \tau) \, \phi(u) \, du}{\frac{p}{\sigma} \phi\left( \frac{d}{\sigma} \right) + (1 - p) \int_{\mathbb{R}} g(\sigma u + d; \tau) \, \phi(u) \, du}}

where \eqn{\phi(x)} is the probability density function of the standard normal distribution,
and \eqn{g(\theta; \tau)} is the logistic density function.
}
\keyword{internal}
