% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_calibration_splines.R
\name{functional_calibration_splines}
\alias{functional_calibration_splines}
\title{Functional Data Calibration with Splines}
\usage{
functional_calibration_splines(data, weights, x, n_functions = 10)
}
\arguments{
\item{data}{A matrix \eqn{M} x \eqn{I} where each column represents one sample of the aggregated function — the matrix \eqn{A} in the model.}

\item{weights}{A matrix \eqn{L} x \eqn{I} representing the weight values associated with each sample — the matrix \eqn{y} in the model.}

\item{x}{A numeric vector of values at which the function is evaluated.}

\item{n_functions}{Number of spline basis functions to be used for estimating \eqn{\alpha_l(x)}.}
}
\value{
The function returns a list containing two objects.

\describe{
  \item{\code{alpha}}{A matrix with the estimated functional coefficients \eqn{\alpha}.}
  \item{\code{Plots}}{A list of plot objects, each representing the corresponding function \eqn{\alpha_l(x)}.}
}
}
\description{
This function performs functional calibration based on the following model:

\deqn{A_i(x_m) = \displaystyle \sum_{l=1}^{L} y_{il} \alpha_l(x_m) + e_i(x_m), \quad i = 1,...,I, \quad m = 1,...,M = 2^J}

where the functions \eqn{\alpha_l(x)} are estimated using spline basis functions.

In matrix notation, the model is represented as:

\deqn{A = \alpha y + e}
}
\examples{
functional_calibration_splines(simulated_data$data, simulated_data$weights, simulated_data$x)
functional_calibration_splines(simulated_data$data, simulated_data$weights, simulated_data$x, 12)

}
\references{
Saraiva, M. A., & Dias, R. (2009). Analise não-parametrica de dados funcionais: uma aplicação a quimiometria (Doctoral dissertation, Master’s thesis, Universidade Estadual de Campinas, Campinas).
}
