% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gad.R
\name{gad}
\alias{gad}
\title{General analysis of variance design}
\usage{
gad(object, quasi.f = FALSE)
}
\arguments{
\item{object}{an object of class lm, containing the specified design with random and/or fixed factors.}

\item{quasi.f}{logical, indicating whether to use quasi F-ratio when there is no single error term appropriate in the analysis. Default to \code{FALSE}.}
}
\value{
A "\code{list}" containing an object of class \code{"anova"} inheriting from class \code{"data.frame"}.
}
\description{
Fits a general ANOVA design with any combination of orthogonal/nested and fixed/random factors through function \code{\link{estimates}}.
}
\details{
Function \code{gad} returns an analysis of variance table using \code{\link{estimates}} to identify the appropriate F-ratios and consequently p-values for any complex model of orthogonal or nested, fixed or random factors as described by Underwood(1997).
}
\examples{
# Example 1
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
model <- lm(wing ~ CG + MQ\%in\%CG, data = rohlf95)
model.tab <- gad(model)
model.tab

# Example 2
data(rats)
TR <- as.fixed(rats$treat)
RA <- as.random(rats$rat)
LI <- as.random(rats$liver)
model2 <- lm(glycog ~ TR + RA\%in\%TR + LI\%in\%RA\%in\%TR, data = rats)
model2.tab <- gad(model2)
model2.tab

# Example 3
data(snails)
O <- as.random(snails$origin)
S <- as.random(snails$shore)
B <- as.random(snails$boulder)
C <- as.random(snails$cage)
model3 <- lm(growth ~ O + S + O*S + B\%in\%S + O*(B\%in\%S) + C\%in\%(O*(B\%in\%S)), data = snails)
model3.tab <- gad(model3)
model3.tab # 'no test' for shore
model3.tab2 <- gad(model3, quasi.f = TRUE)
model3.tab2 # suitable test for shore
}
\references{
Underwood, A.J. 1997. \emph{Experiments in Ecology}: Their Logical Design and Interpretation Using Analysis of Variance. Cambridge University Press, Cambridge.
}
\seealso{
\code{\link{estimates}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
