% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NaiveEstimation_RealData.R
\name{NaiveEstimation_RealData}
\alias{NaiveEstimation_RealData}
\title{Estimating parameters along with corresponding variances based on Naive model with real data.}
\usage{
NaiveEstimation_RealData(
  ITER,
  MHiteration,
  eps,
  mm,
  time,
  MuxStar0,
  MuxInd0,
  SigmaxStar0,
  SigmaxInd0,
  Sigmav0,
  Sigmaw0,
  lambda0,
  sigma0,
  delta0,
  alpha0,
  beta10,
  beta20,
  beta30,
  beta40,
  InfPeriod,
  Di,
  D,
  Nlabel,
  n,
  cov1,
  cov2,
  ww,
  vv,
  tau
)
}
\arguments{
\item{ITER}{The number of simulation runs}

\item{MHiteration}{The number of iterations in Metropolis–Hastings algorithm}

\item{eps}{Stopping value for MCECM algorithm}

\item{mm}{Number of areas.}

\item{time}{Maximum time.}

\item{MuxStar0}{Mean vector of unobserved areal level covariates.}

\item{MuxInd0}{Mean vector of unobserved individual level covariates.}

\item{SigmaxStar0}{Variance of unobserved areal level covariates.}

\item{SigmaxInd0}{Variance of unobserved individual level covariates.}

\item{Sigmav0}{Variance of areal level measurement error variable.}

\item{Sigmaw0}{Variance of individual level measurement error variable.}

\item{lambda0}{Spatial dependency parameter.}

\item{sigma0}{Over dispersion parameter.}

\item{delta0}{The spatial parameter.}

\item{alpha0}{Initial value for intercept.}

\item{beta10}{Initial value for coefficient of observed individual level covariates.}

\item{beta20}{Initial value for coefficient of observed areal level covariates.}

\item{beta30}{Initial value for coefficient of unobserved individual level covariates.}

\item{beta40}{Initial value for coefficient of unobserved areal level covariates.}

\item{InfPeriod}{The infectious period length.}

\item{Di}{Euclidean distance between individuals}

\item{D}{Neibourhood structure}

\item{Nlabel}{Label for each sample from the area}

\item{n}{Total number of individuals}

\item{cov1}{observed individual level covariates}

\item{cov2}{observed areal level covariates}

\item{ww}{Unobserved individual level covariates}

\item{vv}{unobserved areal level covariates}

\item{tau}{tau}
}
\value{
The results of the function
}
\description{
Estimating parameters along with corresponding variances based on Naive model with real data.
}
\examples{
NaiveEstimation_RealData(1,5,0.05,4,20,0.1,0.1,0.15,0.8,0.6,0.6,
0.85,1.1,2.7,0,1,0,1,1,3,
matrix(runif(900,min = 4,max = 20),nrow=30, byrow = TRUE),
matrix(c(2,-1,-1,0,-1,2,0,-1,-1,0,2,-1,0,-1,-1,2),nrow=4,byrow=TRUE),
rep(1:4,c(7,6,8,9)),30,runif(30, 0, 1),
runif(4,0,1),runif(30,-2,2),runif(4,0,1),
sample(c(0,1),replace = TRUE, size = 30))


}
