% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_species_distribution.R
\name{GIFT_species_distribution}
\alias{GIFT_species_distribution}
\title{GIFT species distribution}
\usage{
GIFT_species_distribution(
  genus = "Fagus",
  epithet = "sylvatica",
  namesmatched = FALSE,
  remove_overlap = FALSE,
  area_th_island = 0,
  area_th_mainland = 100,
  overlap_th = 0.1,
  by_ref_ID = FALSE,
  aggregation = FALSE,
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{genus}{Character string corresponding to the genus of the species
of interest.}

\item{epithet}{Character string corresponding to the epithet of the species
of interest.}

\item{namesmatched}{Logical \code{FALSE} by default, set to TRUE if you want to
look for the species not only in the standardized species names but also
in the original species names as they came in the original resources.}

\item{remove_overlap}{a logical stating whether you want to
retrieve checklists that overlap or not. \code{FALSE} by default.}

\item{area_th_island}{A number stating from which surface the smallest
overlapping polygon is kept. By default set to 0 square kilometer
(meaning that by default the smallest islands will be conserved).}

\item{area_th_mainland}{When two polygons overlap, the smallest or the
biggest one can be kept. When the surface of the smallest polygon exceeds
this number, the smallest polygon is kept. Otherwise, we keep the bigger
one. Set by default 100 square-kilometers.}

\item{overlap_th}{A number ranging from 0 to 1, indicating at what
percentage of overlap, partially overlapping polygons should be kept.}

\item{by_ref_ID}{logical indicating whether the removal of overlapping
regions shall be applied by ref_ID only. Note that regions overlapping with
other regions from the same resource will be removed even if there are other
references available for those regions.}

\item{aggregation}{A logical stating whether you want to aggregate in a
simpler way the floristic status of species per entity_ID. For example, two
lists associated to the same entity_ID could describe a species both as
native and non-native. In that case, the aggregation would consider the
species to be native. Reverse for naturalized and alien.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with 33 columns.
}
\description{
Retrieve the distribution of one species from GIFT checklists.
}
\details{
Here is the detail of each data.frame and their columns:
\emph{ref_ID} - Identification number of the reference\cr
\emph{list_ID} - Identification number of the list\cr
\emph{entity_ID} - Identification number of the polygon\cr
\emph{name_ID} - Identification number of the genus before taxonomic
harmonization\cr
\emph{cf_genus} - Whether the genus name is uncertain\cr
\emph{cf_species} - Whether the species' epithet is uncertain\cr
\emph{aff_species} - Species' epithet uncertain\cr
\emph{questionable} - Whether the species name is questionable\cr
\emph{native} - Is the species native\cr
\emph{quest_native} - Is the native status questionable\cr
\emph{naturalized} - Is the species naturalized\cr
\emph{endemic_ref} - Is the species endemic at the reference level\cr
\emph{quest_end_ref} - Is the endemic_ref status questionable\cr
\emph{endemic_list} - Is the species endemic at the list level\cr
\emph{quest_end_list} - Is the endemic_list status questionable\cr
\emph{genus} - Genus name before taxonomic harmonization\cr
\emph{species_epithet} - Epithet before taxonomic harmonization\cr
\emph{subtaxon} - Subtaxon name before taxonomic harmonization\cr
\emph{author} - Author who described the species before taxonomic
harmonization\cr
\emph{matched} - Is the species name matched in the taxonomic backbone\cr
\emph{epithetscore} - Matching score for the epithet\cr
\emph{overallscore} - Overall matching score for the species\cr
\emph{resolved} - Is the species name resolved in the taxonomic backbone\cr
\emph{synonym} -Is the species a synonym in the taxonomic backbone\cr
\emph{matched_subtaxon} -Is the sub-species name matched in the taxonomic
backbone\cr
\emph{accepted} - Is the species name accepted in the taxonomic backbone\cr
\emph{service} - Service use for the taxonomic harmonization\cr
\emph{work_ID} -Identification number of the species after taxonomic
harmonization\cr
\emph{taxon_ID} -Identification number of the taxonomic group\cr
\emph{work_genus} - Identification number of the genus after taxonomic
harmonization\cr
\emph{work_species_epithet} - Identification number of the species epithet
after taxonomic harmonization\cr
\emph{work_species} - Species name (after taxonomic harmonization)\cr
\emph{work_author} - Author who described the species (after taxonomic
harmonization)
}
\examples{
\donttest{
ex <- GIFT_species_distribution()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_species_lookup]{GIFT_species_lookup()}}
}
