% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIplot.R
\name{GIplot}
\alias{GIplot}
\alias{GIplot.default}
\alias{GIplot.formula}
\title{Gaussian Interval Plot (GIplot)}
\usage{
GIplot(x, ...)

\method{GIplot}{default}(
  x,
  ...,
  horizontal = TRUE,
  names = c(),
  add = FALSE,
  at = 0,
  valueOfc = 2.33,
  axisLabel = "",
  main = paste("GI Plot of ", axisLabel),
  spsize = T
)

\method{GIplot}{formula}(
  formula,
  dataset = NULL,
  horizontal = TRUE,
  names = c(),
  add = FALSE,
  at = 0,
  valueOfc = 2.33,
  axisLabel = "",
  main = paste("GIPlot of ", axisLabel),
  spsize = T,
  ...
)
}
\arguments{
\item{x}{a numeric vector or a single list or a data frame}

\item{...}{more numeric vectors for the GIplot}

\item{horizontal}{Logical.TRUE (Default) for horizontal GIPlot and FALSE for vertical.}

\item{names}{names of the sub-groups for which separate GIPlots are drawn on the same scale.}

\item{add}{Logical. TRUE adds a new GIplot to the existing plot. FALSE (Default) will create a new plot.}

\item{at}{If add = TRUE, the position at which the new GIplot should be placed.}

\item{valueOfc}{the multiplier of sd to determine extreme bounds beyond which values are flagged as outliers. To flag alpha proportion of data in each tail use c = qnorm(1-alpha). When alpha = 0.01, c = qnorm(0.99) = 2.32}

\item{axisLabel}{label for the axis}

\item{main}{title of the GIplot.}

\item{spsize}{Logical. TRUE (Default) adds a sample size to the GIplot.}

\item{formula}{a formula, such as x ~ grp, where x is a numeric vector of data values to be split into groups according to the grouping variable grp (usually a factor). Note that ~ g1 + g2 is equivalent to g1:g2.}

\item{dataset}{a data.frame from which the variables in formula should be taken.}
}
\value{
displays the GIplot
}
\description{
The Gaussian Interval Plot (GIplot) is a pictorial representation of the mean
             and the standard deviation of a quantitative variable. It also flags
             potential outliers (together with their frequencies) that are c standard deviations away from the mean.
}
\examples{
  #For vectors
  x<- rnorm(90,30,10)
  GIplot(x)

  #For Formula Class
  groupA <- rep(c(1,2,3),30)
  GIplot(x~groupA)

}
