% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMcatMethods.R
\name{summary.glmcat}
\alias{summary.glmcat}
\title{Summary method for a fitted \code{glmcat} model object}
\usage{
\method{summary}{glmcat}(object, normalized = FALSE, correlation = FALSE, ...)
}
\arguments{
\item{object}{an fitted object of class `glmcat`.}

\item{normalized}{if `TRUE`, the summary method yields the normalized coefficients.}

\item{correlation}{if `TRUE`, prints the correlation matrix.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Summary method for a fitted `glmcat` model object.
}
\examples{
mod1 <- discrete_cm(formula = choice ~ hinc + gc + invt,
                    case_id = "indv", alternatives = "mode", reference = "air",
                    data = TravelChoice,  alternative_specific = c("gc", "invt"),
                    cdf = "normal", normalization = 0.8)
summary(mod1, normalized = TRUE)
}
