% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNSSseg.R
\name{GNSSseg}
\alias{GNSSseg}
\title{Homogeneization of GNSS series}
\usage{
GNSSseg(
  Data,
  lyear = 365.25,
  lmin = 1,
  Kmax = 30,
  selection.K = "BM_BJ",
  S = 0.75,
  f = TRUE,
  selection.f = FALSE,
  threshold = 0.001,
  tol = 1e-04
)
}
\arguments{
\item{Data}{a data frame, with size [n x 2], containing the signal (e.g. the daily GPS-ERAI series for GNSS) and the dates (in format yyyy-mm-dd of type "calendar time" (class POSIXct))}

\item{lyear}{the length of the year in the signal. Default is 365.25}

\item{lmin}{the minimum length of the segments. Default is 1}

\item{Kmax}{the maximal number of segments (must be lower than n). Default is 30}

\item{selection.K}{a name indicating the model selection criterion to select the number of segments K (\code{mBIC}, \code{Lav}, \code{BM_BJ} or \code{BM_slope}). \code{"none"} indicates that no selection is claimed and the procedure considers \code{Kmax} segments or \code{Kmax}-1 changes. If \code{selection.K="All"}, the results for the four possible criteria are given. Default is \code{"BM_BJ"}}

\item{S}{the threshold used in the Lav's criterion. Default is 0.75}

\item{f}{a boolean indicating if the functional part is taking into account in the model. Default is TRUE and note that if \code{f=FALSE}, only a segmentation is performed}

\item{selection.f}{a boolean indicating if a selection on the functions of the Fourier decomposition of order 4 is performed. Default is FALSE}

\item{threshold}{a numeric value lower than 1 used for the selection of the functions of the Fourier decomposition of order 4. Default is 0.001}

\item{tol}{the stopping rule for the iterative procedure. Default is 1e-4}
}
\value{
A file containing
\itemize{
\item \code{K} that corresponds to the selected number of segments or \code{K}-1 corresponds to the number of changes. If \code{selection.K="none"}, the number of segments is \code{Kmax}.
\item \code{seg} that corresponds to the estimation of the segmentation parameters (the begin and the end positions of each segment with the estimated mean).
\item \code{funct} that corresponds to the estimation of the functional part. If \code{f==FALSE}, \code{funct} is FALSE
\item \code{coeff} that corresponds to the estimation of the coefficients of the Fourier decomposition. The vector contains 8 coefficients if \code{selection.f=FALSE} or as many coefficients as the number of selected functions if \code{selection.f=TRUE}. If \code{f==FALSE}, \code{coeff} is FALSE
\item \code{variances} that corresponds to the estimated variances of each fixed interval
\item \code{SSR} that corresponds to the Residuals Sum of Squares for k=1,...,\code{Kmax}. If \code{selection.K="none"}, it contains only the SSR for \code{Kmax} segments
\item \code{Tot} is a list. Each component contains all the results k segments (k=1,...,\code{Kmax}). If \code{selection.K="none"}, \code{Tot} is NA
}
If \code{selection.K="All"}, the outputs \code{K}, \code{seg}, \code{funct} and \code{coeff} are each a list containing the corresponding results obtained for the four model selection criteria
}
\description{
fit a segmentation in the mean model by taken into account for a functional part and a heterogeneous variance (default is monthly)
}
\details{
The function performs homogeneization of GNSS series. The considered model is such that: (1) the average is composed of a piecewise function (changes in the mean) with a functional part and (2) the variance is heterogeneous on fixed intervals. By default the latter intervals are the months.
The inference procedure consists in two steps. First, the number of segments is fixed to \code{Kmax} and the parameters are estimated using the maximum likelihood procedure using the following procedure: first the variances are robustly estimated and then the segmentation and the functional parts are iteratively estimated. Then the number of segments is chosen using model selection criteria. The possible criteria are \code{mBIC} the modified BIC criterion, \code{Lav} the criterion proposed by Lavielle, \code{BM_BJ} and \code{BM_slope} the criteriain which the penalty constant is calibrated using the Biggest Jump and the slope.
\itemize{
\item The data is a data frame with 2 columns: $signal is the signal to be homogeneized (a daily series) and $date is the date. The date will be in format yyyy-mm-dd of type "calendar time" (class POSIXct).
\item The function part is estimated using a Fourier decomposition of order 4 with \code{selection.f=FALSE}. \code{selection.f=TRUE} consists in selecting the significative functions of the Fourier decomposition of order 4 (for which p.values are lower than \code{threshold})
\item If \code{selection.K="none"}, the procedure is performed with \code{Kmax} segments.
\item Missing data in the signal are accepted.
}
}
\examples{
data(Data)
lyear=365.25
Kmax=4
lmin=1
result=GNSSseg(Data,lyear,Kmax=Kmax,selection.K="none")
plot_GNSS(Data,result$seg,result$funct)
}
