% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_m_sigma.R
\name{compute_m_sigma}
\alias{compute_m_sigma}
\title{Compute mean, credible interval, and covariate balance in standard Gaussian
process (GP)}
\usage{
compute_m_sigma(
  hyperparam,
  outcome_data,
  treatment_data,
  covariates_data,
  w,
  gps_m,
  tuning,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{hyperparam}{A vector of values of hyper-parameters.
\itemize{
\item First element: alpha
\item Second element: beta
\item Third element: g_sigma (gamma / sigma)
}}

\item{outcome_data}{A  vector of outcome data.}

\item{treatment_data}{A vector of treatment data.}

\item{covariates_data}{A data frame of covariates data.}

\item{w}{A vector of exposure levels at which the CERF is estimated.}

\item{gps_m}{An S3 gps object including:
gps: A data.frame of GPS vectors.
- Column 1: GPS
- Column 2: Prediction of exposure for covariate of each data sample
(e_gps_pred).
- Column 3: Standard deviation of  e_gps (e_gps_std)
used_params:
- dnorm_log: TRUE or FLASE}

\item{tuning}{The function is used for parameter tuning (default = TRUE)
or estimation (FALSE)}

\item{kernel_fn}{The covariance function of GP.}
}
\value{
A list containing two elements:
\itemize{
\item A vector of absolute weighted correlation of each covariate to the
exposure, which is the metric for covariate balance
\item An estimated CERF at \code{w_all} based on the hyper-parameter values in
\code{param}.
}
}
\description{
Calculates the induced covariate balance associated with one hyper-parameter
configuration in standard GP.
}
\keyword{internal}
